create temp table months(m int primary key, name text);
insert into months(m, name) values (1, 'January');
insert into months(m, name) values (2, 'February');
insert into months(m, name) values (3, 'March');
insert into months(m, name) values (4, 'April');
insert into months(m, name) values (5, 'May');
insert into months(m, name) values (6, 'June');
insert into months(m, name) values (7, 'July');
insert into months(m, name) values (8, 'August');
insert into months(m, name) values (9, 'September');
insert into months(m, name) values (10, 'October');
insert into months(m, name) values (11, 'November');
insert into months(m, name) values (12, 'December');

@break-page(0)
@column-sizes(1|5|1|2|2|5|2|1)
@key-columns(1,2,3,4)

--	(select spaces(gettoken(content,2), gettoken(content,1)) from entityFTS where rowid=e.docID) as 'Name of Poison',  -- regno, name

select 
	m.name || ' ' || strftime('%Y', date(tdate/1000, 'unixepoch', 'localtime')) as "Month", 
	(select multilines(gettoken(content,1),gettoken(content,7)) from entityFTS where rowid=ec.docID) as "Name", 
	sh.id as "Id",
	sh.refNo as "Inv No",
	tdate as "Date@date", 
	(select gettoken(content,1) from entityFTS where rowid=e.docID) as 'Name of Poison', 
	et.purposeOfSales as "Usage",
	-p.quantity as "Qty@number"
from poisonusage p
inner join months m on (m.m = strftime('%m', date(tdate/1000, 'unixepoch', 'localtime')))
inner join salesheader sh on sh.id=p.sales_id
inner join entity e on e.id=p.stockID
inner join entity ec on ec.id=p.consumedByID
inner join entityattributes ea on ea.entityid = e.id
inner join entityterm et on ec.id=et.entityid
inner join types cat on (cat.id = ea.typeid and cat.parentid=(select value from ul_keys where key='ScheduleTypeGroupID'))
where p.type='S'
order by tdate, sales_id, 5;
