@ifPDF
	@column-sizes(2|2|1|3|2|7|1|2|2|2)
	@row-function(|||||||||c[7]-c[8])
	@footer(|||||*||sum|sum|sum)
@end
select 
	dt as "DATE@datetime",
@ifExcel
	receiptNo as "RECEIPT@integer",
@end
@ifPDF
	receiptNo as "RECEIPT",
@end
	seq as "SEQ@integer",
	cat as CATEGORY,
	code as CODE, 
	name as NAME, 
	qty as "QTY@integer", 
	value as "VALUE@dividefactor@sum=sum", 
	cost as "COST@dividefactor@sum=sum", 
@ifExcel
	0 as "GROSS@decimal@formula=H@row-I@row"
@end
@ifPDF
	0 as "GROSS@decimal"
@end
from (
select  
   cat.name as cat,
   transactionDate as dt,
   sh.id as receiptNo,
   getseqSales(transactionDate, sh.id, sh.salestype) as seq,
   (select gettoken(content,0) from entityFTS where rowid=e.docID) as code,
   (select gettoken(content,1) from entityFTS where rowid=e.docID) as name, 
   quantity*ifnull(packsize,1) as qty, 
   quantity*price as value,
   quantity*round(costprice*sp.packsize,2) as cost 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join types cat on cat.id=s.typeid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
where sd.IsDeleted is NULL and sh.isDeleted is NULL and transactionDate between @fromdate and @todate and value < cost and qty > 0 =@salestype
) t 
order by name,dt desc;
