-- next statement will run cube report for succeeding sql statement @group(nDimesion, meas0 aggregate op, meas1 aggregate op)
@ifPDF
	@column-sizes(3|7|2|2|2|2|2|2|2|2|2)
	@break-page(0)
	@footer(|*|sum|sum|sum|sum|sum|sum|(c[2]-c[4])/c[2]*100|(c[4]-c[7])/c[7]*100|sum)
@end
@ifExcel
	@group(2,sum,sum,sum,sum,sum,sum,sum)
@end
select 
	cashier as "CASHIER", 
    item as "ITEMS SOLD",
	sum(valueB4disc) as "RETAIL@dividefactor", 
	sum(valueWithGST-gst) as "SOLD AMT@dividefactor@sum=sum",
    sum(effectiveAmount-effectiveGST) as "ACTUAL@dividefactor",
    sum(valueB4disc - (effectiveAmount-effectiveGST)) as "DISC@dividefactor",
	sum(costWithoutGST) as "COST@dividefactor", 	
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "PROFIT@dividefactor", 	
	sum(cast(valueB4disc - (effectiveAmount-effectiveGST) as real))/sum(cast(valueB4disc as real))*100.0 as "%DISC@decimal",
	sum(cast(effectiveAmount - effectiveGST - costWithoutGST as real))/sum(cast(costWithoutGST as real))*100.0 as "+-COST%@decimal",
	sum(effectiveAmount) as "COLLECTION@dividefactor@sum=sum"
from DailySalesSummaryByCashier
group by cashier, item
having case when costWithoutGST = 0 then 9999.99 else sum(cast(effectiveAmount - effectiveGST - costWithoutGST as real))/sum(cast(costWithoutGST as real))*100.0 end =@margin
order by cashier, item;

-- DailySalesSummaryByCashier(id, cashier, gstcode, date, dateOnly, salesType, item, valueWithGST, costWithoutGST, gst, discount, discountAtTotal, rounding, terminal)

@ifPDF
	@column-sizes(7|2|2|2|2|2|2|2|2|2)
	@footer(*|sum|sum|sum|sum|sum|sum|(c[1]-c[3])/c[1]*100|(c[3]-c[6])/c[6]*100|sum)
@end

select 
	cashier as "CASHIER",
	sum(valueB4disc) as "RETAIL@dividefactor", 
	sum(valueWithGST-gst) as "SOLD AMT@dividefactor@sum=sum",
    sum(effectiveAmount-effectiveGST) as "ACTUAL@dividefactor",
    sum(valueB4disc - (effectiveAmount-effectiveGST)) as "DISC@dividefactor",
	sum(costWithoutGST) as "COST@dividefactor", 	
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "PROFIT@dividefactor", 	
	sum(cast(valueB4disc - (effectiveAmount-effectiveGST) as real))/sum(cast(valueB4disc as real))*100.0 as "%DISC@decimal",
	sum(cast(effectiveAmount - effectiveGST - costWithoutGST as real))/sum(cast(costWithoutGST as real))*100.0 as "+-COST%@decimal",
	sum(effectiveAmount) as "COLLECTION@dividefactor@sum=sum"
from DailySalesSummaryByCashier
group by cashier
having sum(cast(effectiveAmount - effectiveGST - costWithoutGST as real))/sum(cast(costWithoutGST as real))*100.0 =@margin
order by 1,2;

