-- DailySalesSummaryByPromoter(id, cashier, gstcode, date, dateOnly, salesType, item, valueWithGST, costWithoutGST, gst, discount, discountAtTotal, rounding, terminal)
@ifExcel
	@group(2,,,sum,sum,sum,sum,sum,sum,sum)
@end
@ifPDF
	@column-sizes(3|3|4|7|2|2|2|2|2|2|2|2|2)
	@footer(|||*|sum|sum|sum|sum|sum|sum|(c[4]-c[6])/c[4]*100|(c[6]-c[9])/c[9]*100|sum)
@end
select 
	dateOnly as "Date@date",
	date as "Time@time",
	promoter as promoter, 
	item as Item,
	valueB4disc as "RETAIL@dividefactor@sum=sum",
	valueWithGST-gst as "SOLD AMT@dividefactor@sum=sum",
	effectiveAmount-effectiveGST as "ACTUAL@dividefactor@sum=sum", 
	valueB4disc - (effectiveAmount-effectiveGST) as "DISC@dividefactor@sum=sum", 
	effectiveGST as "GST@dividefactor", 	
	costWithoutGST as "COST@dividefactor", 	
	(cast(valueB4disc as real) - (cast(effectiveAmount-effectiveGST as real)))/cast(valueB4disc as real)*100.0 as "%DISC@decimal",
	marginAboveCost as "+-COST%@decimal",
	effectiveAmount as "COLLECTION@dividefactor@sum=sum"
from DailySalesSummaryByPromoter where marginAboveCost =@margin
order by date;

