attach 'master.db' as m;

select 
	dt as "DATE@datetime",
	receiptNo as "RECEIPT",
	cat as CATEGORY,
	qty as "QTY@integer", 
	value as "VALUE@dividefactor@sum=sum", 
	cost as "COST@dividefactor@sum=sum"
from (
select  
   cat.name as cat,
   transactionDate as dt,
   sh.id as receiptNo,
   quantity*ifnull(packsize,1) as qty, 
   quantity*price as value,
   quantity*round(costprice,2)*sp.packsize as cost 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join types cat on cat.id=s.typeid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
where sd.stockid=4647 and value < cost and qty > 0
) t 
order by dt desc;


select  
   cat.name as cat,
   transactionDate as dt,
   sh.id as receiptNo,
   quantity*ifnull(packsize,1) as qty, 
   price as price,
   costprice as costprice,
   quantity*price as value,
   quantity*round(costprice,2)*sp.packsize as cost 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join types cat on cat.id=s.typeid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
where sd.stockid=4647
order by sd.salesid
;