
@ifExcel
	@column-sizes(2|6|2|2|2|2|2|1)
	select 
		sh.id  as INVOICE, 
		(select spaces(gettoken(content,1), '[', gettoken(content,0), ']' ) from entityFTS where rowid=e.docID) as CUSTOMER,
		sh.date as "DATE@date",
		sum(case when effectiveGST=0 then effectiveAmount else 0 end) as "ZR@dividefactor@sum=sum",
		sum(case when effectiveGST!=0 then effectiveAmount-effectiveGST else 0 end) as "SR@dividefactor@sum=sum",
		sum(effectiveGST) as "GST@dividefactor@sum=sum",
		sum(effectiveAmount) as "TOTAL@dividefactor@sum=sum",
		s.term as "TERM@number"
	from DailySalesSummaryByCategory sh
	inner join salesheader s on s.id=sh.id
	inner join entity e on e.id=sh.customerID
	group by 1
	order by 1;
@end

@ifPDF
	@column-sizes(6|2|2|2|2)
	@footer(*|sum|sum|sum|sum)
	select 
		(select spaces(gettoken(content,1), '[', gettoken(content,0), ']' ) from entityFTS where rowid=e.docID) as CUSTOMER,
		sum(case when effectiveGST=0 then effectiveAmount else 0 end) as "ZR@dividefactor@sum=sum",
		sum(case when effectiveGST!=0 then effectiveAmount-effectiveGST else 0 end) as "SR@dividefactor@sum=sum",
		sum(effectiveGST) as "GST@dividefactor@sum=sum",
		sum(effectiveAmount) as "TOTAL@dividefactor@sum=sum"
	from DailySalesSummaryByCategory sh
	inner join entity e on e.id=sh.customerID
	group by 1
	order by 1;

	@column-sizes(2|6|2|2|2|2|2|1)
	@footer(||*|sum|sum|sum|sum)
	select 
		sh.id  as INVOICE, 
		(select spaces(gettoken(content,1), '[', gettoken(content,0), ']' ) from entityFTS where rowid=e.docID) as CUSTOMER,
		transactionDate as "DATE@date",
		sum(case when effectiveGST=0 then effectiveAmount else 0 end) as "ZR@dividefactor@sum=sum",
		sum(case when effectiveGST!=0 then effectiveAmount-effectiveGST else 0 end) as "SR@dividefactor@sum=sum",
		sum(effectiveGST) as "GST@dividefactor@sum=sum",
		sum(effectiveAmount) as "TOTAL@dividefactor@sum=sum",
		s.term as "TERM@number"
	from DailySalesSummaryByCategory sh
	inner join salesheader s on s.id=sh.id
	inner join entity e on e.id=sh.customerID
	group by 1
	order by 1;
@end