select 
	type as 'TYPE', 
	'-' as 'DATE',
	sum(taxAmount) as "GST@dividefactor@sum=sum", 
	sum(value) as "VALUE@dividefactor@sum=sum", 
	sum(value+taxAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(cost) as "COST@dividefactor@sum=sum", 
	sum(value-cost) as "GROSS@dividefactor@sum=sum",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@decimal" 
from (
select  
   t.name as type,
   0 as month, 
   sum(quantity*ifnull(packsize,1)) as qty, 
   sum(quantity*price) as value,
   sum(quantity*round(costprice,2)*sp.packsize) as cost, 
   sum(case when gstcode=(select value from ul_keys where key='GSTMarker') then ifnull(taxAmount,0) else 0 end) as taxAmount
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
inner join types t on t.id=sh.salestype
where transactionDate between @fromdate and @todate
and sh.salestype = (select value from ul_keys where key= 'CashSalesTypeID') and sd.IsDeleted is NULL and sh.isdeleted is null
group by t.name
) t 
group by type
order by 1;

select * from (
select '', 'Discount at Total' as 'OTHER COSTS', sum(discountAtTotal) as '@dividefactor' from salesheader st where isDeleted is NULL and transactionDate between @fromdate and @todate and salestype = (select value from ul_keys where key= 'CashSalesTypeID')
union all 
select '', 'Rounding' as '', sum(roundingAmount) as '@dividefactor' from salesheader sh where isDeleted is NULL and transactionDate between @fromdate and @todate and salestype = (select value from ul_keys where key= 'CashSalesTypeID')
union all
select '', 'GST' as '', sum(totalTaxAmount) as 'GST@dividefactor' from salesheader sh where isDeleted is NULL and transactionDate between @fromdate and @todate and salestype = (select value from ul_keys where key= 'CashSalesTypeID')
) t;

select 
	type as 'TYPE', 
	cat as 'CATEGORY', 
	sum(taxAmount) as "GST@dividefactor@sum=sum", 
	sum(value) as "VALUE@dividefactor@sum=sum", 
	sum(value+taxAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(cost) as "COST@dividefactor@sum=sum", 
	sum(value-cost) as "GROSS@dividefactor@sum=sum",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@decimal" 
from (
select  
   t.name as type,
   t2.name as cat, 
   sum(quantity*ifnull(packsize,1)) as qty, 
   sum(quantity*price) as value,
   sum(quantity*round(costprice,2)*sp.packsize) as cost,
   sum(case when gstcode=(select value from ul_keys where key='GSTMarker') then ifnull(taxAmount,0) else 0 end) as taxAmount
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join types t2 on t2.id=s.typeID
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
inner join types t on t.id=sh.salestype
where sd.IsDeleted is NULL and sh.isDeleted is NULL and sh.transactionDate between @fromdate and @todate 
and sh.salestype = (select value from ul_keys where key= 'CashSalesTypeID')
group by t.name, t2.name
) t 
group by type, cat
order by 1, cat;


select 
	type as "TYPE", 
	yr as "YEAR", 
	sum(taxAmount) as "GST@dividefactor@sum=sum", 
	sum(value) as "VALUE@dividefactor@sum=sum", 
	sum(value+taxAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(cost) as "COST@dividefactor@sum=sum", 
	sum(value-cost) as "GROSS@dividefactor@sum=sum",
	sum(cast(value-cost as real))/sum(value)*100 as "MARGIN@decimal" 
from (
select  
   t.name as type,
   strftime('%Y', date(transactionDate/1000,'unixepoch', 'localtime')) as yr, 
   sum(quantity*ifnull(packsize,1)) as qty, 
   sum(quantity*price) as value,
   sum(quantity*round(costprice,2)*sp.packsize) as cost,
   sum(case when gstcode=(select value from ul_keys where key='GSTMarker') then ifnull(taxAmount,0) else 0 end) as taxAmount 
from salesdetail sd
inner join salesheader sh on sh.id=sd.salesid
inner join stock s on s.entityid=sd.stockid
inner join stockpackmaster sp on sp.stockid=sd.stockid and sp.packtypeid=sd.packtypeid
inner join entity e on e.id=s.entityid
inner join entityfts ef on ef.rowid=e.docid
inner join types t on t.id=sh.salestype
where sd.IsDeleted is NULL and sh.isDeleted is NULL and sh.transactionDate between @fromdate and @todate
and sh.salestype = (select value from ul_keys where key= 'CashSalesTypeID')
group by t.name, strftime('%Y', date(transactionDate/1000,'unixepoch', 'localtime'))
) t 
group by type, yr
order by 1, 2 desc;
