-- dependency on temp table DailySalesSummaryByCategory(id, date, salesType, category, valueWithGST, costWithoutGST, gst)
-- generated by command-before='generatedailysalessummarybycategory' in the ServerSideMenu.xml for the definition of the job 
-- using filter userParam="salesType in (select value from ul_keys where key='CashSalesType')"

@ifPDF
	@column-sizes(2|3|2|2|2|2|2|2)
	@row-function(|||||||c[6]/c[3]*100)
	@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@end
select 
	'GST' as 'Report', 
	gstcode as 'GST Code', 
	sum(effectiveGST) as "GST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST) as "VALUE@dividefactor@sum=sum", 
    sum(effectiveAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(costWithoutGST) as "COST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "GROSS@dividefactor@sum=sum",
@ifPDF
	0 as "MARGIN@decimal" 
@ifExcel
	0 as "MARGIN@decimal@formula=G@row/D@row*100" 
@end
from DailySalesSummaryByCategory
group by 2
order by 2;

@ifPDF
	@column-sizes(2|3|2|2|2|2|2|2)
	@row-function(|||||||c[6]/c[3]*100)
	@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@end
select 
	gstcode as 'GST Code', 
    category as 'CATEGORY',
	sum(effectiveGST) as "GST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST) as "VALUE@dividefactor@sum=sum", 
    sum(effectiveAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(costWithoutGST) as "COST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "GROSS@dividefactor@sum=sum",
@ifPDF
	0 as "MARGIN@decimal" 
@ifExcel
	0 as "MARGIN@decimal@formula=G@row/D@row*100" 
@end
from DailySalesSummaryByCategory
group by 1, 2
order by 1, 2;

@ifPDF
	@column-sizes(2|3|2|2|2|2|2|2)
	@row-function(|||||||c[6]/c[3]*100)
	@footer(|*|sum|sum|sum|sum|sum|c[6]/c[3]*100)
@end
select 
	gstcode as 'GST Code', 
    strftime('%Y', date(d.date/1000,'unixepoch', 'localtime')) as "Year",
	sum(effectiveGST) as "GST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST) as "VALUE@dividefactor@sum=sum", 
    sum(effectiveAmount) as "COLLECTION@dividefactor@sum=sum", 
	sum(costWithoutGST) as "COST@dividefactor@sum=sum", 
	sum(effectiveAmount-effectiveGST-costWithoutGST) as "GROSS@dividefactor@sum=sum",
@ifPDF
	0 as "MARGIN@decimal" 
@ifExcel
	0 as "MARGIN@decimal@formula=G@row/D@row*100" 
@end
from DailySalesSummaryByCategory d
group by 1, 2
order by 1, 2 desc;
