attach 'Pharmacy.sqlite3db' as master;        

select 
    (select 
        sum(quantity*(case when sp.packsize=0 or sp.packsize='' or sp.packsize is NULL then 1 else sp.packsize end) + 
        ifnull(bonusQty,0)*(case when spb.packsize=0 or spb.packsize='' or spb.packsize is NULL then 1 else spb.packsize end)) as Qty 
    from ReceiveDetail rd 
    inner join ReceiveHeader rh on rd.receiveID=rh.id 
    inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
    inner join stockpackmaster spb on spb.stockid=rd.stockid and spb.packtypeid=rd.bonuspacktypeid 
    where rd.stockid=s.entityid and rd.isDeleted is NULL and rh.isDeleted is NULL) as qRecv, 
    
    (select   
        sum(quantity * (case when sp.packsize=0 or sp.packsize='' or sp.packsize is NULL then 1 else sp.packsize end) + 
        ifnull(bonusQty,0)*(case when spb.packsize=0 or spb.packsize='' or spb.packsize is NULL then 1 else spb.packsize end)) as Qty
    from SalesDetail rd 
    inner join SalesHeader rh on rd.salesid=rh.id 
    inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
    inner join stockpackmaster spb on spb.stockid=rd.stockid and spb.packtypeid=rd.bonuspacktypeid 
    where rd.stockid=s.entityID and rd.isDeleted is NULL and rh.isDeleted is NULL) as qSales, 

    (select sum(quantity * (case when packsize=0 or packsize='' or packsize is NULL then 1 else packsize end)) as Qty 
    from StockTransDetail rd 
    inner join StockTransHeader rh on rd.stocktransid=rh.id 
    inner join stockpackmaster sp on sp.stockid=rd.stockid and 
    sp.packtypeid=rd.packtypeid 
    where rd.stockid=s.entityID and rd.isDeleted is NULL and rh.isDeleted is NULL) as qAdj 

from stock s where entityID=194 and s.isDeleted is NULL;

/*
         select 
               1 as Type, 
               strftime('%Y-%m', datetime(rh.transactiondate/1000, \unixepoch\, \localtime\)) as YYYYMM, 
               sum(quantity*(case when sp.packsize=0 or sp.packsize='' or sp.packsize is NULL then 1 else sp.packsize end) + 
                   ifnull(bonusQty,0)*(case when spb.packsize=0 or spb.packsize='' or spb.packsize is NULL then 1 else spb.packsize 
            end)) as Qty 
            from ReceiveDetail rd 
            inner join ReceiveHeader rh on rd.receiveID=rh.id 
            inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
            inner join stockpackmaster spb on spb.stockid=rd.stockid and spb.packtypeid=rd.bonuspacktypeid 
            where rd.stockid=? and rh.isdeleted is null and rd.isdeleted is null 
            group by 2 ));

            select 
               2 as Type, 
               strftime('%Y-%m', datetime(rh.transactiondate/1000, \unixepoch\, \localtime\)) as YYYYMM, 
               sum(quantity * (case when sp.packsize=0 or sp.packsize='' or sp.packsize is NULL then 1 else sp.packsize end) + 
                   ifnull(bonusQty,0)*(case when spb.packsize=0 or spb.packsize='' or spb.packsize is NULL then 1 else spb.packsize end)) as Qty 
            from SalesDetail rd 
            inner join SalesHeader rh on rd.salesid=rh.id 
            inner join stockpackmaster sp on sp.stockid=rd.stockid and sp.packtypeid=rd.packtypeid 
            inner join stockpackmaster spb on spb.stockid=rd.stockid and spb.packtypeid=rd.bonuspacktypeid 
            where rd.stockid=? and rh.isdeleted is null and rd.isdeleted is null and rh.salestype = (select value from ul_keys where key='CashSalesTypeID')
            group by 2 ));

*/