pragma foreign_keys = off;
drop table if exists SAC;
drop index if exists idx_StockAdditionalCharges;
alter table StockAdditionalCharges rename to SAC;
create table StockAdditionalCharges(
				stockID integer,
				fromDate integer,
				toDate integer,
				typeID integer,
				percentage integer,
				fixedValue integer,
				foreign key(stockID) references Stock(id),
				foreign key(typeID) references Types(id)
);
create index idx_StockAdditionalCharges on StockAdditionalCharges(stockID, typeID, fromDate, toDate);
delete from StockAdditionalCharges;
insert into StockAdditionalCharges(stockID, fromDate, toDate, typeID, percentage, fixedValue) select stockID, fromDate, toDate, typeID, percentage, fixedValue from SAC where fromDate < strftime('%s','2018-06-01 00:00:00+08:00')*1000; 

update stockadditionalcharges set toDate = strftime('%s','2018-05-31 23:59:59+08:00')*1000 where percentage > 0;

insert into stockadditionalcharges(stockID, fromDate, toDate, typeID, percentage)
select 
   stockID,
   strftime('%s','2018-06-01 00:00:00+08:00')*1000,
   strftime('%s','9999-12-31 23:59:59+08:00')*1000,
   typeID,
   0
from stockadditionalcharges where fromDate < strftime('%s','2018-05-31 23:59:59+08:00')*1000 and percentage > 0;

update stockadditionalcharges set toDate = 1527782399000 where percentage > 0;
update stockadditionalcharges set toDate = 253402271999000 where todate > 253402271999000;