attach 'Pharmacy.sqlite3db' as mast;

drop table temp.toUpdate;

create temp table toUpdate as 
select id, price, costprice, sq.maxcost/spm.packsize as maxcost, sq.latestcost/spm.packsize as latestcost
from salesdetail sd
inner join stockqoh sq on sq.stockid=sd.stockid
inner join stockpackmaster spm on (spm.stockid=sd.stockid and spm.packtypeid=sd.packtypeid)
where sd.price <= sd.costprice*packsize
;

create index temp.idx_temp_toUpdate on toUpdate(id);

update salesdetail set costprice = (select latestcost from toUpdate where salesdetail.id=toUpdate.id)
where id in (select id from toUpdate);