
@column-sizes(5|2|2|2|2|2|2|2|2)

select 
	(select gettoken(content, 1) from entityfts ef inner join entity e on e.docid=ef.rowid where e.id=supplierId) as "Supplier",
	transactionDate as "Invoice Date@date", 
	duedate as "Due Date@date", 
	refNo as "Reference", 
	amount as "Amount@dividefactor", 
	amount-ifnull(totalPaid,0) as "Outstanding@dividefactor",
	paidOn as "Paid On", 
	paidBy as "Paid By", 
	payRef as "Pay Ref"
from (
	select 
		h.transactionDate, 
		h.transactionDate+h.term as duedate, 
		h.id, 
		h.refNo, 
		(select sum(amount) from ReceiveDetail where isDeleted is NULL and receiveID=h.id) as Amount, 
		(select group_concat(dt) from ( 
			select strftime('%d-%m-%Y', datetime(p.transactionDate/1000, 'unixepoch', 'localtime')) as dt from PaymentMade p where receiveID=h.id and p.isDeleted is null 
			union 
			select strftime('%d-%m-%Y', datetime(jh.transactionDate/1000, 'unixepoch', 'localtime')) as dt from journaldetail jd inner join journalheader jh on jh.id=jd.journalID where jd.transactionID=h.id 
		) t 
		) as paidOn, 
		(select group_concat(name) from ( 
			select distinct(t.name) from types t inner join PaymentMade p on (p.paidBy=t.id) where abs(p.paidAmount) > 0.009 and receiveID=h.id and p.isDeleted is null 
			union 
			select (select distinct(gettoken(content, 1)) from entityfts ef inner join entity e on e.docid=ef.rowid where e.id=jh.fromAccount) as name from journaldetail jd 
			inner join journalheader jh on jh.id=jd.journalid 
			where jd.transactionID=h.id 
		) t 
		) as paidBy, 
		(select group_concat(refNo) from ( 
			select distinct(p.remark) as refNo from PaymentMade p where receiveID=h.id and p.isDeleted is null 
			union 
			select distinct(jh.refNo) as refNo from journaldetail jd 
			inner join journalheader jh on jh.id=jd.journalid 
			where jd.transactionID=h.id 
		) t 
		) as payRef, 
		(select sum(amount) from ( 
			select paidAmount as amount from PaymentMade p where receiveID=h.id and p.isDeleted is null 
			union all 
			select jd.amount as amount from journaldetail jd where jd.transactionID=h.id 
		) t 
		) as totalPaid,
		supplierID 
	from ReceiveHeader h 
) t 
where ifnull(totalPaid,0) < Amount-1
order by DueDate desc;
