create table if not exists private.tempItemList(receiveID integer, stockID integer);
create index if not exists private.idx_tempItemList on tempItemList(receiveID, stockID);
delete from private.tempItemList;
insert into private.tempItemList
	select rh.id as receiveID, rd.stockid
	from receivedetail rd 
	inner join receiveheader rh on rh.id=rd.receiveid 
	inner join entity e on e.id=rd.stockid 
	where rd.isdeleted is null and rh.supplierid = @supplierid and rh.isdeleted is null and rd.quantity > 0
	group by rd.stockID having max(rh.transactionDate);

@column-sizes(1|5|1|1|1|1|2)

select 
	gettoken(ef.content,0) as "ITEM CODE", 
	gettoken(ef.content,1) as "ITEM NAME", 
	formatqoh(rd.stockID, getQOH(sq)) as "QOH", 
	rd.price as "Price@dividefactor",
	rd.quantity || t.code as "Quantity@integer", 
	rd.bonusQty || t2.code as "Bonus@integer", 
	rh.transactionDate as "Date@date"
from ReceiveDetail rd
inner join ReceiveHeader rh on rd.receiveID=rh.id 
inner join types t on t.id=rd.packtypeid 
inner join entity e on e.id=rd.stockID 
inner join entityfts ef on ef.rowid=e.docid
inner join stockQOH sq on sq.stockID=rd.stockID 
inner join types t2 on t2.id=rd.bonuspacktypeid 
where rd.isdeleted is null and rh.isdeleted is null 
and exists(select * from private.tempItemList where receiveID=rh.id and stockID=rd.stockID)
order by 2;

